/**
 * This file should be the first in the order
 */
window.WPD = typeof window.WPD !== 'undefined' ? window.WPD : {};
window.WPD.Options = typeof window.WPD.Options !== 'undefined' ?window.WPD.Options : {};
window.WPD.Options._classes = typeof window.WPD.Options._classes !== 'undefined' ?window.WPD.Options._classes : {};
jQuery(function($){
    const classes = window.WPD.Options._classes;window.WPD.Options._classes.AbstractOption = class {
    constructor( target = null ) {
        this.node = target;
        this.init();
    }

    init() {}
};jQuery(function($){
    /**
     * Spectrum: color chooser
     */
    $(".wpdreamsColorPicker .color").spectrum({
        showInput: true,
        showAlpha: true,
        showPalette: true,
        showSelectionPalette: true
    }).on('wd_state_update', function () {
        function hex2rgb(hex, opacity) {
            let rgb = hex.replace('#', '').match(/(.{2})/g),
                i = 3;
            while (i--) {
                rgb[i] = parseInt(rgb[i], 16);
            }
            if (typeof opacity == 'undefined') {
                return 'rgb(' + rgb.join(', ') + ')';
            }
            return 'rgba(' + rgb.join(', ') + ', ' + opacity + ')';
        }

        let val = $(this).val();
        if ( val.length <= 7 ) {
            val = hex2rgb(val, 1);
        }
        $(this).spectrum("set", val);
    });
});jQuery(function($) {
    $('div.wd_cf_search').each(function () {
        var timeout = null;
        var parent = this;
        var id = $(this).attr('id').match(/^wd_cf_search-(.*)/)[1];
        var $res = $('.wd_cf_search_res', parent);

        $("input.wd_cf_search", parent).on('keyup', function () {
            var $this = $(this);
            clearTimeout(timeout);
            if ($this.val() == '') {
                $('.wd_ts_close', parent).addClass("hiddend");
                $('.loading-small', parent).addClass("hiddend");
                return;
            }
            timeout = setTimeout(function () {
                $('.loading-small', parent).removeClass("hiddend");
                $('.wd_ts_close', parent).addClass("hiddend");
                var data = {
                    'action': 'wd_search_cf',
                    'wd_phrase': $this.val(),
                    'wd_required': 1,
                    'wd_args': $("input.wd_args", parent).val()
                };
                $.post(ajaxurl, data, function (response) {
                    var o = JSON.parse(WD_Helpers.Base64.decode($("input.wd_args", parent).val()));
                    var reg = new RegExp(o.delimiter + '(.*[\s\S]*)' + o.delimiter);
                    var data_r = response.match(reg);
                    data_r = JSON.parse(data_r[1]);
                    if (typeof o.callback != 'undefined' && o.callback != '') {
                        if (typeof window[o.callback] != 'undefined')
                            window[o.callback].apply(null, [data_r, $this, o, parent, id]);
                    } else {
                        var html = '';
                        $.each(data_r, function (i, v) {
                            html += '<li key="' + v.meta_key + '">' + v.meta_key + '</li>';
                        });
                        if (html != '')
                            $res.html('<ul>' + html + '</ul>');
                        else
                            $res.html('<p>No results :(</p>');

                        $res.css('display', 'block');
                        var bottom_of_element = $this.offset().top + $res.outerHeight();
                        var bottom_of_screen = $(window).scrollTop() + window.innerHeight;
                        if ((bottom_of_element > bottom_of_screen)) {
                            $res.css({
                                left: $this.position().left + $this.outerWidth(true) + 5,
                                top: $this.position().top - (bottom_of_element - bottom_of_screen),
                                display: 'block',
                                minWidth: $this.width()
                            });
                        } else {
                            $res.css({
                                left: $this.position().left,
                                top: $this.position().top + $this.outerHeight(true) + 10,
                                display: 'block',
                                minWidth: $this.width()
                            });
                        }

                        $res.find('li').on('click', function (e) {
                            $this.val($(this).attr('key'));
                            $res.css({display: 'none'});
                        });
                    }
                    $('.loading-small', parent).addClass("hiddend");
                    $('.wd_ts_close', parent).removeClass("hiddend");
                }, "text");
            }, 350);
        });
        $('.wd_ts_close', parent).on('click', function () {
            $("input.wd_cf_search", parent).val('');
            $(this).addClass("hiddend");
            $res.css({
                display: 'none'
            });
        });
        $("input.wd_cf_search", parent).on('click', function () {
            $res.css({
                display: 'block'
            });
        });
        $("input.wd_cf_search", parent).on('blur', function () {
            $(this).val($(this).val().trim());
        });
        $(parent).click("click", function (e) {
            e.stopImmediatePropagation();
        });
        $(document).off('click.wpd_custom_field_search').on('click.wpd_custom_field_search', function () {
            $('.wd_ts_close', parent).addClass("hiddend");
            $res.css({display: 'none'});
        });
    });
    /**
     * EXAMPLE HANDLER
     window.my_js_function_name = function(r, $node, o) {
        //console.log(r, $node, o);
    };
     */
});jQuery(function($) {
    /**
     * Custom field selectors
     */
    window.wd_cf_ajax_callback = function(r, $node, o, parent) {
        var $cf_parent = $node.closest('.wpdreamsCustomFields');
        var $drg = $(".draggablecontainer ul", $cf_parent);
        var id = $cf_parent.attr('id').match(/^wpdreamsCustomFields-(.*)/)[1];
        var html = '';
        var drag_opts = {
            connectToSortable: "#sortable_conn" + id,
            update: function (event, ui) {},
            cancel: ".ui-state-disabled",
            helper: "clone",
            items: "> li"
        };
        if ( r.length > 0 ) {
            $.each(r, function(i, v) {
                var title = v.meta_key.replace('__pods__', '[PODs] ');
                html += '<li class="ui-state-default" cf_name="'+v.meta_key+'">'+title+'<a class="deleteIcon"></a></li>';
            });
            $drg.html(html);
            $("#sortable" + id + " li").draggable(drag_opts).disableSelection();
            $("#sortable" + id + " li").trigger('sortupdate');
            $("#sortable_conn" + id).trigger('sortupdate');
        } else {
            $drg.html('No results for this phrase.');
        }
    }
    $('div.wpdreamsCustomFields').each(function(){
        var id = $(this).attr('id').match(/^wpdreamsCustomFields-(.*)/)[1];
        var name = $('input[isparam=1]', this).attr('name');
        var parent = $(this);
        var hidden = $('input[isparam=1]', this);

        function list_update() {
            $("#sortable" + id + " li").removeClass("ui-state-disabled");
            $('ul[id*=sortable_conn] li', parent).each(function (i, v) {
                $("#sortable" + id + " li[cf_name='"+$(this).attr('cf_name')+"']").addClass("ui-state-disabled");
            });
        }

        function data_update() {
            var items = $("#sortable_conn" + id + " li")
            var val = "";
            items.each(function () {
                val += "|" + $(this).attr('cf_name');
            });
            val = val.substring(1);
            hidden.val(val);
        }

        $("#sortable_conn" + id).sortable({
            update: function (event, ui) {
                var $item = $(ui.item);
                $item.css({
                    "width": "",
                    "height": ""
                });
                list_update();
                data_update();
            },
            items: "> li",
            cancel: ".ui-state-disabled",
            remove: function(event, ui) {}
        }).disableSelection();

        $("#sortable_conn" + id).on('sortupdate', function(event, ui) {
            list_update();
            data_update();
        });

        $("#sortable_conn" + id).on( "click", "li a.deleteIcon", function(e){
            e.preventDefault();
            $(this).parent().detach();
            list_update();
            data_update();
        });

        $("#draggablecontainer" + id + " .arrow-all-left").on('click', function(){
            $("#sortable_conn" + id + " li").detach();
            $("#sortable_conn" + id).trigger('sortupdate');
        });
        $("#draggablecontainer" + id + " .arrow-all-right").on('click', function(){
            $("#sortable" + id + " li:not(.hiddend):not(.ui-state-disabled)").clone().appendTo("#sortable_conn" + id);
            $("#sortable_conn" + id).trigger('sortupdate');
        });
    });
});jQuery(function($){
    $('.wd_imageRadio img.image_radio').on('click', function() {
        var $parent = $(this).parent();
        var $hidden = $("input[isparam]", $parent);
        $('img.selected', $parent).removeClass('selected');
        $(this).addClass('selected');
        $hidden.val($(this).data('value')).trigger('change')
    });
    $('.wd_imageRadio input[type=hidden]').on('wd_state_update', function () {
        let $parent = $(this).closest('.wd_imageRadio');
        $parent.find('img.selected').removeClass('selected');
        $parent.find('img[data-value="' + $(this).val() + '"]').addClass('selected');
        $(this).trigger('change');
    });
});jQuery(function($){
    /**
     * @description determine if an array contains one or more items from another array.
     * @param {array} haystack the array to search.
     * @param {array} arr the array providing items to check for in the haystack.
     * @return {boolean} true|false if haystack contains at least one item from arr.
     */
    let findOne = function (haystack, arr) {
        return arr.some(function (v) {
            return haystack.indexOf(v) >= 0;
        });
    };
    let mimes = {
        'pdf': [
            'application/pdf'
        ],
        'text' : [
            'text/plain',
            'text/csv',
            'text/tab-separated-values',
            'text/calendar',
            'text/css',
            'text/html'
        ],
        'richtext' : [
            'text/richtext',
            'application/rtf'
        ],
        'mso_word' : [
            'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
            'application/vnd.ms-word.document.macroEnabled.12',
            'application/vnd.openxmlformats-officedocument.wordprocessingml.template',
            'application/vnd.ms-word.template.macroEnabled.12',
            'application/vnd.oasis.opendocument.text'
        ],
        'mso_excel' : [
            'application/vnd.ms-excel',
            'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
            'application/vnd.ms-excel.sheet.macroEnabled.12',
            'application/vnd.ms-excel.sheet.binary.macroEnabled.12',
            'application/vnd.openxmlformats-officedocument.spreadsheetml.template',
            'application/vnd.ms-excel.template.macroEnabled.12',
            'application/vnd.ms-excel.addin.macroEnabled.12',
            'application/vnd.oasis.opendocument.spreadsheet',
            'application/vnd.oasis.opendocument.chart',
            'application/vnd.oasis.opendocument.database',
            'application/vnd.oasis.opendocument.formula'
        ],
        'mso_powerpoint' : [
            'application/vnd.ms-powerpoint',
            'application/vnd.openxmlformats-officedocument.presentationml.presentation',
            'application/vnd.ms-powerpoint.presentation.macroEnabled.12',
            'application/vnd.openxmlformats-officedocument.presentationml.slideshow',
            'application/vnd.ms-powerpoint.slideshow.macroEnabled.12',
            'application/vnd.openxmlformats-officedocument.presentationml.template',
            'application/vnd.ms-powerpoint.template.macroEnabled.12',
            'application/vnd.ms-powerpoint.addin.macroEnabled.12',
            'application/vnd.openxmlformats-officedocument.presentationml.slide',
            'application/vnd.ms-powerpoint.slide.macroEnabled.12',
            'application/vnd.oasis.opendocument.presentation',
            'application/vnd.oasis.opendocument.graphics'
        ],
        'image': [
            'image/jpeg',
            'image/gif',
            'image/png',
            'image/bmp',
            'image/tiff',
            'image/x-icon'
        ],
        'video': [
            'video/x-ms-asf',
            'video/x-ms-wmv',
            'video/x-ms-wmx',
            'video/x-ms-wm',
            'video/avi',
            'video/divx',
            'video/x-flv',
            'video/quicktime',
            'video/mpeg',
            'video/mp4',
            'video/ogg',
            'video/webm',
            'video/x-matroska'
        ],
        'audio': [
            'audio/mpeg',
            'audio/x-realaudio',
            'audio/wav',
            'audio/ogg',
            'audio/midi',
            'audio/x-ms-wma',
            'audio/x-ms-wax',
            'audio/x-matroska'
        ]
    };

    $('.wd_MimeTypeSelect .file_mime_types_list select').select2().on('change', function(){
        let values = [];
        $(this).val().forEach(function(v){
            values.push(mimes[v].join(','));
        });
        $(this).closest('.wd_MimeTypeSelect').find('.file_mime_types_input textarea')
            .val(values.join(',')).trigger('input').trigger('click');
    });

    $('.wd_MimeTypeSelect .file_mime_types_input textarea').on('click keyup change cut paste', function(){
        let val = $(this).val().toLowerCase().replace(' ', '');
        let vals_arr = val.split(',');
        let selected_mimes = [];

        if ( vals_arr.length > 0 ) {
            $.each(vals_arr, function(i, v){
                vals_arr[i] = v.trim();
            });
            $.each(mimes, function(i, v){
                $.each(v, function(ii, vv){
                    mimes[i][ii] = vv.toLowerCase();
                });
            });
            $.each(mimes, function(k, arr){
                if ( findOne(arr, vals_arr) ) {
                    selected_mimes.push(k);
                }
            });
        }

        $(this).closest('.wd_MimeTypeSelect')
            .find('.file_mime_types_list select').val(selected_mimes).trigger('change.select2');
    }).trigger('click');

    $('span.mime_input_hide').on('click', function(){
        let $p = $(this).closest('.wd_MimeTypeSelect');
        $p.find('.file_mime_types_input').addClass('hiddend')
        $p.find('.file_mime_types_list').removeClass('hiddend');
    });
    $('span.mime_list_hide').on('click', function(){
        let $p = $(this).closest('.wd_MimeTypeSelect');
        $p.find('.file_mime_types_input').removeClass('hiddend')
        $p.find('.file_mime_types_list').addClass('hiddend');
        $p.find('.file_mime_types_input textarea').trigger('input');
    });
});jQuery(function($){
    $('div.wd_cpt_search').each(function() {
        var timeout = null;
        var parent = this;
        var id = $(this).attr('id').match(/^wd_cpt_search-(.*)/)[1];
        var $res = $('.wd_cpt_search_res', parent);
        var $param = $('input[isparam]', parent);

        $("input.wd_cpt_search", parent).on('keyup', function() {
            var $this = $(this);
            clearTimeout(timeout);
            if ( $this.val() == '' ) {
                $('.wd_ts_close', parent).addClass("hiddend");
                $('.loading-small', parent).addClass("hiddend");
                return;
            }
            timeout = setTimeout(function () {
                $('.loading-small', parent).removeClass("hiddend");
                $('.wd_ts_close', parent).addClass("hiddend");
                var data = {
                    'action': 'wd_search_cb_cpt',
                    'wd_phrase': $this.val(),
                    'wd_required': 1,
                    'wd_args': $("input.wd_args", parent).val()
                };
                $.post(ajaxurl, data, function (response) {
                    var o = JSON.parse(WD_Helpers.Base64.decode($("input.wd_args", parent).val()));
                    var reg = new RegExp(o.delimiter +'(.*[\s\S]*)'+ o.delimiter);
                    var data_r = response.match(reg);
                    data_r = JSON.parse(data_r[1]);
                    if ( typeof o.callback != 'undefined' && o.callback != '' ) {
                        if ( typeof window[o.callback] != 'undefined' )
                            window[o.callback].apply(null, [data_r, $this, o, parent, id]);
                    } else {
                        var html = '';
                        $.each(data_r, function(i, v){
                           html += '<li key="' + v.ID + '">' + v.post_title + ' (' + v.post_type + ')</li>';
                        });
                        if ( html != '')
                            $res.html('<ul>' + html + '</ul>');
                        else
                            $res.html('<p>No results :(</p>');

                        $res.css('display', 'block');
                        var bottom_of_element = $this.offset().top + $res.outerHeight();
                        var bottom_of_screen = $(window).scrollTop() + window.innerHeight;
                        if( ( bottom_of_element > bottom_of_screen ) ){
                            $res.css({
                                left: $this.position().left + $this.outerWidth(true) + 5,
                                top: $this.position().top - (bottom_of_element - bottom_of_screen),
                                display: 'block',
                                minWidth: $this.width()
                            });
                        } else {
                            $res.css({
                                left: $this.position().left,
                                top: $this.position().top + $this.outerHeight(true) + 10,
                                display: 'block',
                                minWidth: $this.width()
                            });
                        }

                        $res.find('li').on('click', function(e){
                            $this.val('');
                            $this.addClass('hiddend');
                            $(".wp_cpt_search_selected span:not(.fa)", parent).text($(this).text());
                            $(".wp_cpt_search_selected", parent).removeClass('hiddend');
                            $param.val($(this).attr('key'));
                            $res.css({display: 'none'});
                            $('.wd_ts_close', parent).addClass("hiddend");
                        });
                    }
                    $('.loading-small', parent).addClass("hiddend");
                    $('.wd_ts_close', parent).removeClass("hiddend");
                }, "text");
            }, 350);
        });
        $('.wd_ts_close', parent).on('click', function(){
            $("input.wd_cpt_search", parent).val('');
            $(this).addClass("hiddend");
            $res.css({
                display: 'none'
            });
        });
        $("input.wd_cpt_search", parent).on('click', function() {
            $res.css({
                display: 'block'
            });
        });
        $("input.wd_cpt_search", parent).on('blur', function () {
            $(this).val($(this).val().trim());
        });
        $(parent).click("click", function (e) {
            e.stopImmediatePropagation();
        });
        $(".wp_cpt_search_selected", parent).on('click', function () {
            $param.val('');
            $(this).addClass('hiddend');
            $('.wd_ts_close', parent).trigger('click');
            $("input.wd_cpt_search", parent).removeClass('hiddend');
        });
        if ( $(".wp_cpt_search_selected", parent).text().trim() == '' || $(".wp_cpt_search_selected", parent).text().trim() == '()' ) {
            $(".wp_cpt_search_selected", parent).addClass('hiddend');
            $("input.wd_cpt_search", parent).removeClass('hiddend');
        }
        $(document).on('click', function(){
            $('.wd_ts_close', parent).addClass("hiddend");
            $res.css({display: 'none'});
        });
    });
    /**
     * EXAMPLE HANDLER
    window.my_js_function_name = function(r, $node, o) {
        //console.log(r, $node, o);
    };
     */
});jQuery(function($){
    $('div.wd_post_type_sortalbe').each(function(){
        var parent = $(this);
        var id = $(this).attr('id').match(/^wd_post_type_sortalbe-(.*)/)[1];
        var selector = "#sortable" + id +", #sortable_conn" + id;
        var hidden = $('input[isparam=1]', parent);

        $(selector).sortable({}, {
            update: function (event, ui) {}
        }).disableSelection();
        $(selector).on('sortupdate', function(event, ui) {
            var items = $('ul[id*=sortable] li', parent);
            var val = [];
            items.each(function () {
                val.push($(this).html().trim());
            });
            hidden.val( '_decode_' + WD_Helpers.Base64.encode(JSON.stringify(val)) );
        });
        $(selector).trigger("sortupdate");
    });
});jQuery(function($) {
    $('div.wpdreamsCustomPostTypes').each(function () {
        let id = $(this).data('id'),
            selector = "#sortable" + id + ", #sortable_conn" + id,
            parent = $(this),
            hidden = $('input[isparam=1]', this);

        $(selector).sortable({
            connectWith: ".connectedSortable" + id
        }).disableSelection();

        $(selector).on('sortupdate', function(event, ui){
            // Items need to be re-parsed!
            let items = parent.find('ul[id*=sortable_conn] li'),
                val = [];
            items.each(function () {
                val.push($(this).data('ptype'));
            });
            hidden.val("_decode_" + WD_Helpers.Base64.encode(JSON.stringify(val)));
        });

        $("#sortablecontainer" + id + " .arrow-all").on('click', function(){
            if ( $(this).hasClass('arrow-all-left') ) {
                $("#sortable_conn" + id + " li").detach().appendTo("#sortable" + id + "");
            } else {
                $("#sortable" + id + " li:not(.hiddend)").detach().appendTo("#sortable_conn" + id);
            }
            $(selector).trigger("sortupdate");
        });
    });
});jQuery(function($){
    $('div.wpdreamsSortable').each(function(){
        let id = $(this).data('id'),
            selector = "#sortable" + id,
            parent = $(this),
            hidden = $('input[isparam=1]', this);

        $(selector).sortable().disableSelection();
        $(selector).on('sortupdate', function(event, ui){
            // Items need to be re-parsed!
            let items = parent.find('ul[id*=sortable_conn] li'),
                val = [];
            items.each(function () {
                val.push($(this).data('value'));
            });
            hidden.val(val.join('|'));
        });
    });
});jQuery(function($){
    $('div.wpdreamsTaxonomySelect').each(function () {
        let id = $(this).data('id'),
            selector = "#sortable" + id + ", #sortable_conn" + id,
            parent = $(this),
            hidden = $('input[isparam=1]', this);

        $(selector).sortable({
            connectWith: ".connectedSortable" + id
        }).disableSelection();

        $(selector).on('sortupdate', function(event, ui){
            // Items need to be re-parsed!
            let items = parent.find('ul[id*=sortable_conn] li'),
                val = [];
            items.each(function () {
                val.push($(this).data('taxonomy'));
            });
            hidden.val(val.join('|'));
        });

        $("#sortablecontainer" + id + " .arrow-all").on('click', function(){
            if ( $(this).hasClass('arrow-all-left') ) {
                $("#sortable_conn" + id + " li").detach().appendTo("#sortable" + id + "");
            } else {
                $("#sortable" + id + " li:not(.hiddend)").detach().appendTo("#sortable_conn" + id);
            }
            $(selector).trigger("sortupdate");
        });
    });
});jQuery(function($){
    // This needs to be triggered once the window is loaded, otherwise it may have no effect on init
    $('textarea.wd_textarea_expandable').textareaAutoSize();
    var textAuto;
    $('.tabs a[tabid]').on('click', function(){
        clearTimeout(textAuto);
        textAuto = setTimeout(function(){
            $('textarea.wd_textarea_expandable').trigger('input');
        }, 50);
    });
});import {AbstractOption} from './abstract-option.js';
export class Text extends AbstractOption {
    init() {
        const
            _this = this,
            node = this.node;

        if ( typeof ($(node).data('regex')) != 'undefined' && $(node).data('regex') != '' ) {
            this.setDefault();
            node.oldValue = node.value;
            $(node).on('input contextmenu drop focusout', function(e){
                _this.validate(e);
            });
            $(node).on('focusout', function(e){
                _this.setDefault();
            });
        }
    }
    
    setDefault() {
        const node = this.node;
        if (
            $(node).val() === '' &&
            $(node).data('allow_empty') == 0 &&
            $(node).data('default') !== ''
        ) {
            $(node).val($(node).data('default'));
            node.oldValue = $(node).data('default');
        }
    }

    validate(e = false) {
        const node = this.node;
        node.setCustomValidity("");
        if ( $(node).val() != "" ) {
            let pattern = $(node).data('regex');
            let r = new RegExp(pattern, 'g');
            if (!r.test($(node).val())) {
                if ( e !== false ) {

    validate(e = false) {
        const node = this.node;
        node.setCustomValidity("");
        if ( $(node).val() != "" ) {
            let pattern = $(node).data('regex');
            let r = new RegExp(pattern, 'g');
            if (!r.test($(node).val())) {
                if ( e !== false ) {
                    e.preventDefault();
                    e.stopImmediatePropagation();
                }
                node.value = node.oldValue;
                node.setCustomValidity($(node).data('validation_msg'));
                node.reportValidity();
            } else {
                node.oldValue = node.value;
                node.setCustomValidity("");
            }
                node.value = node.oldValue;
                node.setCustomValidity($(node).data('validation_msg'));
                node.reportValidity();
            } else {
                node.oldValue = node.value;
                node.setCustomValidity("");
            }
        }
    }
}jQuery(function($){
    /**
     * wpdreamsUpload - File uploader window
     */
    var custom_uploader, $cup_text;
    $('.wpdreamsUpload .wdUploadButton').on('click', function(e){
        e.preventDefault();
        $cup_text = $(this).parent().find('input.wdUploadText');
        //If the uploader object has already been created, reopen the dialog
        if ( custom_uploader ) {
            custom_uploader.open();
            return;
        }

        //Extend the wp.media object
        custom_uploader = wp.media.frames.file_frame = wp.media({
            title: 'Choose File',
            button: {
                text: 'Choose File'
            },
            multiple: false
        });

        //When a file is selected, grab the URL and set it as the text field's value
        custom_uploader.on('select', function () {
            var attachment = custom_uploader.state().get('selection').first().toJSON();
            $cup_text.val(attachment.url).trigger('change');
        });

        //Open the uploader dialog
        custom_uploader.open();
    });
});jQuery(function ($){
    window.wd_um_ajax_callback = function(r, $node, o, parent) {
        var $cf_parent = $node.closest('.wd_UserMeta');
        var $drg = $(".draggablecontainer ul", $cf_parent);
        var id = $cf_parent.attr('id').match(/^wd_UserMeta-(.*)/)[1];
        var html = '';
        var drag_opts = {
            connectToSortable: "#sortable_conn" + id,
            update: function (event, ui) {},
            cancel: ".ui-state-disabled",
            helper: "clone",
            items: "> li"
        };
        if ( r.length > 0 ) {
            $.each(r, function(i, v) {
                html += '<li class="ui-state-default" cf_name="'+v.meta_key+'">'+v.meta_key+'<a class="deleteIcon"></a></li>';
            });
            $drg.html(html);
            $("#sortable" + id + " li").draggable(drag_opts).disableSelection();
            $("#sortable" + id + " li").trigger('sortupdate');
            $("#sortable_conn" + id).trigger('sortupdate');
        } else {
            $drg.html('No results for this phrase.');
        }
    }
    $('div.wd_UserMeta').each(function(){
        var id = $(this).attr('id').match(/^wd_UserMeta-(.*)/)[1];
        var name = $('input[isparam=1]', this).attr('name');
        var parent = $(this);
        var hidden = $('input[isparam=1]', this);

        function list_update() {
            $("#sortable" + id + " li").removeClass("ui-state-disabled");
            $('ul[id*=sortable_conn] li', parent).each(function (i, v) {
                $("#sortable" + id + " li[cf_name='"+$(this).attr('cf_name')+"']").addClass("ui-state-disabled");
            });
        }

        function data_update() {
            var items = $("#sortable_conn" + id + " li")
            var fields = [];
            items.each(function () {
                fields.push($(this).attr('cf_name'));
            });
            hidden.val("_decode_" + WD_Helpers.Base64.encode(JSON.stringify(fields)));
        }

        $("#sortable_conn" + id).sortable({
            update: function (event, ui) {
                var $item = $(ui.item);
                $item.css({
                    "width": "",
                    "height": ""
                });
                list_update();
                data_update();
            },
            items: "> li",
            cancel: ".ui-state-disabled",
            remove: function(event, ui) {}
        }).disableSelection();

        $("#sortable_conn" + id).on('sortupdate', function(event, ui) {
            list_update();
            data_update();
        });

        $("#sortable_conn" + id).on( "click", "li a.deleteIcon", function(e){
            e.preventDefault();
            $(this).parent().detach();
            list_update();
            data_update();
        });

        $("#draggablecontainer" + id + " .arrow-all-left").on('click', function(){
            $("#sortable_conn" + id + " li").detach();
            $("#sortable_conn" + id).trigger('sortupdate');
        });
        $("#draggablecontainer" + id + " .arrow-all-right").on('click', function(){
            $("#sortable" + id + " li:not(.hiddend):not(.ui-state-disabled)").clone().appendTo("#sortable_conn" + id);
            $("#sortable_conn" + id).trigger('sortupdate');
        });
    });
});jQuery(function($){
    $('div.wpdreamsUserRoleSelect').each(function () {
        let id = $(this).data('id'),
            selector = "#sortable" + id + ", #sortable_conn" + id,
            parent = $(this),
            hidden = $('input[isparam=1]', this);

        $(selector).sortable({
            connectWith: ".connectedSortable" + id
        }).disableSelection();

        $(selector).on('sortupdate', function(event, ui){
            // Items need to be re-parsed!
            let items = parent.find('ul[id*=sortable_conn] li'),
                val = [];
            items.each(function () {
                val.push($(this).data('role'));
            });
            hidden.val(val.join('|'));
        });

        $("#sortablecontainer" + id + " .arrow-all").on('click', function(){
            if ( $(this).hasClass('arrow-all-left') ) {
                $("#sortable_conn" + id + " li").detach().appendTo("#sortable" + id + "");
            } else {
                $("#sortable" + id + " li:not(.hiddend)").detach().appendTo("#sortable_conn" + id);
            }
            $(selector).trigger("sortupdate");
        });
    });
});jQuery(function($){
    $('div.wd_userselect').each(function(){
        var id = $(this).attr('id').match(/^wd_userselect-(.*)/)[1];
        var selector = "#sortable" + id +", #sortable_conn" + id;
        var hidden = $('input[isparam=1]', this);
        var name = hidden.attr('name');
        var parent = $(this);
        var actualData = JSON.parse( WD_Helpers.Base64.decode(hidden.val().replace(/^(_decode_)/,"")) );
        var _cache = "";

        function tt_s_update( parent ) {
            // Items need to be re-parsed!
            var items = $('ul[id*=sortable_conn] li', parent);
            var users = [];
            var un_checked = [];
            items.each(function (i, v) {
                users.push($(this).data('userid'));
                if ( $("input[type='checkbox']", this).length > 0 && !$("input[type='checkbox']", this).get(0).checked )
                    un_checked.push($(this).data('userid'));
            });
            actualData.users = users;
            actualData.op_type = $(".tts_operation", parent).val();
            actualData.un_checked = un_checked;
            hidden.val("_decode_" + WD_Helpers.Base64.encode(JSON.stringify(actualData)));
        }

        function list_update() {
            $("#sortable" + id + " li").removeClass("ui-state-disabled");
            $('ul[id*=sortable_conn] li', parent).each(function (i, v) {
                $("#sortable" + id + " li[data-userid='"+$(this).data('userid')+"']").addClass("ui-state-disabled");
            });
        }

        var drag_opts = {
            connectToSortable: "#sortable_conn" + id,
            update: function (event, ui) {},
            cancel: ".ui-state-disabled",
            helper: "clone"
        };
        $("#sortable" + id + " li").draggable(drag_opts).disableSelection();

        $("#sortable_conn" + id).sortable({
            update: function (event, ui) {
                var $item = $(ui.item);
                $item.css({
                    "width": "",
                    "height": ""
                });
                if ( $item.data("userid") == '-1' ) {
                    $("#sortable_conn" + id + " li[data-userid!='-1']").detach();
                } else {
                    $("#sortable_conn" + id + " li[data-userid='-1']").detach();
                }
                // Refresh cache with remaining
                _cache = $("#sortable" + id).html();
                tt_s_update( parent );
                list_update();
            },
            cancel: ".ui-state-disabled",
            remove: function(event, ui) {
                var $item = $(ui.item);
                _cache = "";
            }
        }).disableSelection();

        var timeout = null;
        $(".wd_user_search", parent).on('keyup', function(){
            var $this = $(this);
            clearTimeout(timeout);
            timeout = setTimeout(function(){
                $('.dragLoader', parent).removeClass("hiddend");
                var data = {
                    'action': 'wd_search_users',
                    'wd_phrase': $this.val(),
                    'wd_required': 1,
                    'wd_args': $("input.wd_args", parent).val()
                };
                $.post(ajaxurl, data, function (response) {
                    if (response.length > 0) {
                        _cache = response;
                        $("#sortable" + id).html(response);
                        $("#sortable" + id + " li").draggable(drag_opts).disableSelection();
                        list_update();
                        $('.dragLoader', parent).addClass("hiddend");
                        $(".hide-children", parent).trigger('change');
                    }
                }, "text");
            }, 350);
        });

        $(selector).on('sortupdate', function(event, ui) {
            tt_s_update( parent );
            list_update();
        });
        $("#sortable_conn" + id +" li input").on('change', function(){
            tt_s_update( parent );
            list_update();
        });
        $("#sortable_conn" + id).on( "click", "li a.deleteIcon", function(e){
            e.preventDefault();
            $(this).parent().detach();
            tt_s_update( parent );
            list_update();
        });

        $(".tts_operation", parent).on('change', function(){
            tt_s_update( parent );
            list_update();
            $(".tts_type", parent).html($(this).val());
        });

        tt_s_update( parent );
        list_update();
    });
});jQuery(function($){
    $('div.wpdreamsBP_XProfileFields').each(function () {
        let id = $(this).data('id'),
            selector = "#sortable" + id + ", #sortable_conn" + id,
            parent = $(this),
            hidden = $('input[isparam=1]', this);

        $(selector).sortable({
            connectWith: ".connectedSortable" + id
        }).disableSelection();

        $(selector).on('sortupdate', function(event, ui){
            // Items need to be re-parsed!
            let items = parent.find('ul[id*=sortable_conn] li'),
                val = [];
            items.each(function () {
                val.push($(this).data('bid'));
            });
            hidden.val(val.join('|'));
        });

        $("#sortablecontainer" + id + " .arrow-all").on('click', function(){
            if ( $(this).hasClass('arrow-all-left') ) {
                $("#sortable_conn" + id + " li").detach().appendTo("#sortable" + id + "");
            } else {
                $("#sortable" + id + " li:not(.hiddend)").detach().appendTo("#sortable_conn" + id);
            }
            $(selector).trigger("sortupdate");
        });
    });
});// window.WPD.Options._classes.Text
$('div.wpdreamsText input[type=text]').each(function(){
    this.OptionController = new classes.Text(this);
});/**
 * Last file in order, for closing bracket
 */
});