class SmokyGhostTrail{constructor(t,e={}){if(this.targetElement=this._validateTarget(t),!this.targetElement)throw Error("Invalid target element provided");this.defaultOptions={size:.1,tail:{dotsNumber:25,spring:1.4,friction:.3,gravity:0},smile:1,mainColor:"#FAFAFA",borderColor:"#3399CC",isFlatColor:!1,mouseThreshold:.1,zIndex:1e4,pointerEvents:"none"};let i=this._normalizeColors(this.defaultOptions),s=this._normalizeColors(e);this.options=this._mergeOptions(i,s),this.isRunning=!1,this.animationId=null,this.canvas=null,this.gl=null,this.uniforms=null,this.textureCanvas=null,this.textureCtx=null,this.pointerTrail=[],this.mouse={x:0,y:0,tX:0,tY:0,moving:!1,controlsPadding:0},this.movingTimer=null,this.devicePixelRatio=Math.min(window.devicePixelRatio,2),this._handleMouseMove=this._handleMouseMove.bind(this),this._handleTouchMove=this._handleTouchMove.bind(this),this._handleClick=this._handleClick.bind(this),this._handleResize=this._handleResize.bind(this),this._render=this._render.bind(this),this._init()}_hexToRgb(t){if(Array.isArray(t)){if(3!==t.length)throw Error("RGB array must have exactly 3 values");for(let e=0;e<3;e++)if("number"!=typeof t[e]||t[e]<0||t[e]>1)throw Error("RGB array values must be numbers between 0 and 1");return[...t]}if("string"!=typeof t)throw Error('Color must be a hex string (e.g., "#FF5733") or RGB array');let i=t.replace("#","");if(!/^[0-9A-Fa-f]{3}$|^[0-9A-Fa-f]{6}$/.test(i))throw Error(`Invalid hex color format: "${t}". Use #RGB or #RRGGBB format`);3===i.length&&(i=i.split("").map(t=>t+t).join(""));let s=parseInt(i.substring(0,2),16)/255,o=parseInt(i.substring(2,4),16)/255,r=parseInt(i.substring(4,6),16)/255;return[s,o,r]}_normalizeColors(t){let e={...t};if(void 0!==t.mainColor)try{e.mainColor=this._hexToRgb(t.mainColor)}catch(i){throw Error(`Invalid mainColor: ${i.message}`)}if(void 0!==t.borderColor)try{e.borderColor=this._hexToRgb(t.borderColor)}catch(s){throw Error(`Invalid borderColor: ${s.message}`)}return e}_validateTarget(t){if("string"==typeof t){let e=document.querySelector(t);return e||(console.error(`Element with selector "${t}" not found`),null)}return t instanceof HTMLElement?t:(console.error("Target must be a valid DOM element or CSS selector string"),null)}_mergeOptions(t,e){let i={...t};for(let s in e)e.hasOwnProperty(s)&&("object"!=typeof e[s]||null===e[s]||Array.isArray(e[s])?i[s]=e[s]:i[s]=this._mergeOptions(t[s]||{},e[s]));return i}_init(){try{this._createCanvas(),this._createTextureCanvas(),this._initPointerTrail(),this._initWebGL(),this._setupEventListeners(),this._updateMousePosition(.25*this.targetElement.offsetWidth,.8*this.targetElement.offsetHeight)}catch(t){throw console.error("Failed to initialize SmokyGhostTrail:",t),t}}_createCanvas(){this.canvas=document.createElement("canvas"),this.canvas.style.position="absolute",this.canvas.style.top="0",this.canvas.style.left="0",this.canvas.style.width="100%",this.canvas.style.height="100%",this.canvas.style.zIndex=this.options.zIndex,this.canvas.style.pointerEvents=this.options.pointerEvents;let t=window.getComputedStyle(this.targetElement);"static"===t.position&&(this.targetElement.style.position="relative"),this.targetElement.appendChild(this.canvas)}_createTextureCanvas(){this.textureCanvas=document.createElement("canvas"),this.textureCtx=this.textureCanvas.getContext("2d")}_initPointerTrail(){this.pointerTrail=Array(this.options.tail.dotsNumber);let t=t=>this.options.size*this._getContainerHeight()*(1-.2*Math.pow(3*t/this.options.tail.dotsNumber-1,2));for(let e=0;e<this.options.tail.dotsNumber;e++)this.pointerTrail[e]={x:this.mouse.x,y:this.mouse.y,vx:0,vy:0,opacity:.04+.3*Math.pow(1-e/this.options.tail.dotsNumber,4),bordered:.6*Math.pow(1-e/this.pointerTrail.length,1),r:t(e)}}_getContainerWidth(){return this.targetElement.offsetWidth||window.innerWidth}_getContainerHeight(){return this.targetElement.offsetHeight||window.innerHeight}_initWebGL(){let t=this.canvas.getContext("webgl")||this.canvas.getContext("experimental-webgl");if(!t)throw Error("WebGL is not supported by your browser");this.gl=t;let e=`
            precision mediump float;
            varying vec2 vUv;
            attribute vec2 a_position;

            void main() {
                vUv = .5 * (a_position + 1.);
                gl_Position = vec4(a_position, 0.0, 1.0);
            }
        `,i=`
            precision mediump float;

            varying vec2 vUv;
            uniform float u_time;
            uniform float u_ratio;
            uniform float u_size;
            uniform vec2 u_pointer;
            uniform float u_smile;
            uniform vec2 u_target_pointer;
            uniform vec3 u_main_color;
            uniform vec3 u_border_color;
            uniform float u_flat_color;
            uniform sampler2D u_texture;

            #define TWO_PI 6.28318530718
            #define PI 3.14159265358979323846

            vec3 mod289(vec3 x) { return x - floor(x * (1.0 / 289.0)) * 289.0; }
            vec2 mod289(vec2 x) { return x - floor(x * (1.0 / 289.0)) * 289.0; }
            vec3 permute(vec3 x) { return mod289(((x*34.0)+1.0)*x); }

            float snoise(vec2 v) {
                const vec4 C = vec4(0.211324865405187, 0.366025403784439, -0.577350269189626, 0.024390243902439);
                vec2 i = floor(v + dot(v, C.yy));
                vec2 x0 = v - i + dot(i, C.xx);
                vec2 i1;
                i1 = (x0.x > x0.y) ? vec2(1.0, 0.0) : vec2(0.0, 1.0);
                vec4 x12 = x0.xyxy + C.xxzz;
                x12.xy -= i1;
                i = mod289(i);
                vec3 p = permute(permute(i.y + vec3(0.0, i1.y, 1.0)) + i.x + vec3(0.0, i1.x, 1.0));
                vec3 m = max(0.5 - vec3(dot(x0, x0), dot(x12.xy, x12.xy), dot(x12.zw, x12.zw)), 0.0);
                m = m*m;
                m = m*m;
                vec3 x = 2.0 * fract(p * C.www) - 1.0;
                vec3 h = abs(x) - 0.5;
                vec3 ox = floor(x + 0.5);
                vec3 a0 = x - ox;
                m *= 1.79284291400159 - 0.85373472095314 * (a0*a0 + h*h);
                vec3 g;
                g.x = a0.x * x0.x + h.x * x0.y;
                g.yz = a0.yz * x12.xz + h.yz * x12.yw;
                return 130.0 * dot(m, g);
            }

            vec2 rotate(vec2 v, float angle) {
                float r_sin = sin(angle);
                float r_cos = cos(angle);
                return vec2(v.x * r_cos - v.y * r_sin, v.x * r_sin + v.y * r_cos);
            }

            float eyes(vec2 uv) {
                uv.y -= .5;
                uv.x *= 1.;
                uv.y *= .8;
                uv.x = abs(uv.x);
                uv.y += u_smile * .3 * pow(uv.x, 1.3);
                uv.x -= (.6 + .2 * u_smile);

                float d = clamp(length(uv), 0., 1.);
                return 1. - pow(d, .08);
            }

            float mouth(vec2 uv) {
                uv.y += 1.5;

                uv.x *= (.5 + .5 * abs(1. - u_smile));
                uv.y *= (3. - 2. * abs(1. - u_smile));
                uv.y -= u_smile * 4. * pow(uv.x, 2.);

                float d = clamp(length(uv), 0., 1.);
                return 1. - pow(d, .07);
            }

            float face(vec2 uv, float rotation) {
                uv = rotate(uv, rotation);
                uv /= (.27 * u_size);

                float eyes_shape = 10. * eyes(uv);
                float mouth_shape = 20. * mouth(uv);

                float col = 0.;
                col = mix(col, 1., eyes_shape);
                col = mix(col, 1., mouth_shape);

                return col;
            }

            void main() {
                vec2 point = u_pointer;
                point.x *= u_ratio;

                vec2 uv = vUv;
                uv.x *= u_ratio;
                uv -= point;

                float texture = texture2D(u_texture, vec2(vUv.x, 1. - vUv.y)).r;
                float shape = texture;

                float noise = snoise(uv * vec2(.7 / u_size, .6 / u_size) + vec2(0., .0015 * u_time));
                noise += 1.2;
                noise *= 2.1;
                noise += smoothstep(-.8, -.2, (uv.y) / u_size);

                float face = face(uv, 5. * (u_target_pointer.x - u_pointer.x));
                shape -= face;

                shape *= noise;

                vec3 border = (1. - u_border_color);
                border.g += .2 * sin(.005 * u_time);
                border *= .5;

                vec3 color = u_main_color;
                color -= (1. - u_flat_color) * border * smoothstep(.0, .01, shape);

                shape = u_flat_color * smoothstep(.8, 1., shape) + (1. - u_flat_color) * shape;
                color *= shape;

                gl_FragColor = vec4(color, shape);
            }
        `,s=this._createShader(t,e,t.VERTEX_SHADER),o=this._createShader(t,i,t.FRAGMENT_SHADER),r=this._createShaderProgram(t,s,o);this.uniforms=this._getUniforms(r);let n=new Float32Array([-1,-1,1,-1,-1,1,1,1]),a=t.createBuffer();t.bindBuffer(t.ARRAY_BUFFER,a),t.bufferData(t.ARRAY_BUFFER,n,t.STATIC_DRAW),t.useProgram(r);let h=t.getAttribLocation(r,"a_position");t.enableVertexAttribArray(h),t.bindBuffer(t.ARRAY_BUFFER,a),t.vertexAttribPointer(h,2,t.FLOAT,!1,0,0);let l=t.createTexture();t.bindTexture(t.TEXTURE_2D,l),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MIN_FILTER,t.LINEAR),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MAG_FILTER,t.LINEAR),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_WRAP_S,t.CLAMP_TO_EDGE),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_WRAP_T,t.CLAMP_TO_EDGE),t.texImage2D(t.TEXTURE_2D,0,t.RGBA,t.RGBA,t.UNSIGNED_BYTE,this.textureCanvas),t.uniform1i(this.uniforms.u_texture,0),t.uniform1f(this.uniforms.u_size,this.options.size),t.uniform3f(this.uniforms.u_main_color,...this.options.mainColor),t.uniform3f(this.uniforms.u_border_color,...this.options.borderColor),t.uniform1f(this.uniforms.u_flat_color,this.options.isFlatColor?1:0),this._resizeCanvas()}_createShader(t,e,i){let s=t.createShader(i);return(t.shaderSource(s,e),t.compileShader(s),t.getShaderParameter(s,t.COMPILE_STATUS))?s:(console.error("An error occurred compiling the shaders: "+t.getShaderInfoLog(s)),t.deleteShader(s),null)}_createShaderProgram(t,e,i){let s=t.createProgram();return(t.attachShader(s,e),t.attachShader(s,i),t.linkProgram(s),t.getProgramParameter(s,t.LINK_STATUS))?s:(console.error("Unable to initialize the shader program: "+t.getProgramInfoLog(s)),null)}_getUniforms(t){let e=[],i=this.gl.getProgramParameter(t,this.gl.ACTIVE_UNIFORMS);for(let s=0;s<i;s++){let o=this.gl.getActiveUniform(t,s).name;e[o]=this.gl.getUniformLocation(t,o)}return e}_setupEventListeners(){this.targetElement.addEventListener("mousemove",this._handleMouseMove),this.targetElement.addEventListener("touchmove",this._handleTouchMove),this.targetElement.addEventListener("click",this._handleClick),window.addEventListener("resize",this._handleResize)}_removeEventListeners(){this.targetElement.removeEventListener("mousemove",this._handleMouseMove),this.targetElement.removeEventListener("touchmove",this._handleTouchMove),this.targetElement.removeEventListener("click",this._handleClick),window.removeEventListener("resize",this._handleResize)}_handleMouseMove(t){let e=this.targetElement.getBoundingClientRect();this._updateMousePosition(t.clientX-e.left,t.clientY-e.top)}_handleTouchMove(t){t.preventDefault();let e=this.targetElement.getBoundingClientRect(),i=t.targetTouches[0];this._updateMousePosition(i.clientX-e.left,i.clientY-e.top)}_handleClick(t){let e=this.targetElement.getBoundingClientRect();this._updateMousePosition(t.clientX-e.left,t.clientY-e.top)}_handleResize(){this._resizeCanvas()}_updateMousePosition(t,e){this.mouse.moving=!0,this.mouse.controlsPadding<0&&(this.mouse.moving=!1),clearTimeout(this.movingTimer),this.movingTimer=setTimeout(()=>{this.mouse.moving=!1},300),this.mouse.tX=t;let i=this.options.size*this._getContainerHeight();e-=.6*i,this.mouse.tY=e>i?e:i,this.mouse.tY-=this.mouse.controlsPadding}_resizeCanvas(){let t=this._getContainerWidth(),e=this._getContainerHeight();this.canvas.width=t*this.devicePixelRatio,this.canvas.height=e*this.devicePixelRatio,this.textureCanvas.width=t,this.textureCanvas.height=e,this.gl.viewport(0,0,this.canvas.width,this.canvas.height),this.gl.uniform1f(this.uniforms.u_ratio,this.canvas.width/this.canvas.height);let i=t=>this.options.size*e*(1-.2*Math.pow(3*t/this.options.tail.dotsNumber-1,2));for(let s=0;s<this.options.tail.dotsNumber;s++)this.pointerTrail[s].r=i(s)}_updateTexture(){this.textureCtx.fillStyle="black",this.textureCtx.fillRect(0,0,this.textureCanvas.width,this.textureCanvas.height),this.pointerTrail.forEach((t,e)=>{0===e?(t.x=this.mouse.x,t.y=this.mouse.y):(t.vx+=(this.pointerTrail[e-1].x-t.x)*this.options.tail.spring,t.vx*=this.options.tail.friction,t.vy+=(this.pointerTrail[e-1].y-t.y)*this.options.tail.spring,t.vy*=this.options.tail.friction,t.vy+=this.options.tail.gravity,t.x+=t.vx,t.y+=t.vy);let i=this.textureCtx.createRadialGradient(t.x,t.y,t.r*t.bordered,t.x,t.y,t.r);i.addColorStop(0,"rgba(255, 255, 255, "+t.opacity+")"),i.addColorStop(1,"rgba(255, 255, 255, 0)"),this.textureCtx.beginPath(),this.textureCtx.fillStyle=i,this.textureCtx.arc(t.x,t.y,t.r,0,2*Math.PI),this.textureCtx.fill()})}_render(){if(!this.isRunning)return;let t=performance.now();this.gl.uniform1f(this.uniforms.u_time,t),this.gl.clearColor(0,0,0,1),this.gl.clear(this.gl.COLOR_BUFFER_BIT),this.gl.drawArrays(this.gl.TRIANGLE_STRIP,0,4),this.mouse.moving?(this.options.smile-=.05,this.options.smile=Math.max(this.options.smile,-.1),this.options.tail.gravity-=10*this.options.size,this.options.tail.gravity=Math.max(this.options.tail.gravity,0)):(this.options.smile+=.01,this.options.smile=Math.min(this.options.smile,1),this.options.tail.gravity>25*this.options.size?this.options.tail.gravity=(25+5*(1+Math.sin(.002*t)))*this.options.size:this.options.tail.gravity+=this.options.size),this.mouse.x+=(this.mouse.tX-this.mouse.x)*this.options.mouseThreshold,this.mouse.y+=(this.mouse.tY-this.mouse.y)*this.options.mouseThreshold;let e=this._getContainerWidth(),i=this._getContainerHeight();this.gl.uniform1f(this.uniforms.u_smile,this.options.smile),this.gl.uniform2f(this.uniforms.u_pointer,this.mouse.x/e,1-this.mouse.y/i),this.gl.uniform2f(this.uniforms.u_target_pointer,this.mouse.tX/e,1-this.mouse.tY/i),this._updateTexture(),this.gl.texImage2D(this.gl.TEXTURE_2D,0,this.gl.RGBA,this.gl.RGBA,this.gl.UNSIGNED_BYTE,this.textureCanvas),this.animationId=requestAnimationFrame(this._render)}start(){if(!this.isRunning)return this.isRunning=!0,this._render(),this}stop(){return this.isRunning=!1,this.animationId&&(cancelAnimationFrame(this.animationId),this.animationId=null),this}updateOptions(t){let e=this._normalizeColors(t);if(this.options=this._mergeOptions(this.options,e),this.gl&&this.uniforms){if(void 0!==e.size){this.gl.uniform1f(this.uniforms.u_size,this.options.size);let i=t=>this.options.size*this._getContainerHeight()*(1-.2*Math.pow(3*t/this.options.tail.dotsNumber-1,2));for(let s=0;s<this.options.tail.dotsNumber;s++)this.pointerTrail[s].r=i(s)}void 0!==e.mainColor&&this.gl.uniform3f(this.uniforms.u_main_color,...this.options.mainColor),void 0!==e.borderColor&&this.gl.uniform3f(this.uniforms.u_border_color,...this.options.borderColor),void 0!==e.isFlatColor&&this.gl.uniform1f(this.uniforms.u_flat_color,this.options.isFlatColor?1:0)}return this}getOptions(){return{...this.options}}destroy(){return this.stop(),this._removeEventListeners(),this.canvas&&this.canvas.parentNode&&this.canvas.parentNode.removeChild(this.canvas),this.movingTimer&&clearTimeout(this.movingTimer),this.gl&&this.gl.getExtension("WEBGL_lose_context")?.loseContext(),this.canvas=null,this.gl=null,this.uniforms=null,this.textureCanvas=null,this.textureCtx=null,this.pointerTrail=[],this}isActive(){return this.isRunning}}"undefined"!=typeof module&&module.exports?module.exports=SmokyGhostTrail:"function"==typeof define&&define.amd?define([],function(){return SmokyGhostTrail}):"undefined"!=typeof window&&(window.SmokyGhostTrail=SmokyGhostTrail);