jQuery(document).ready(function($) {

    const isProActive = window._gslogo_admin_data.is_pro_active == 1;


    if ( isProActive && pagenow == 'gs-logo-slider' ) {
        $("#gs_logo_expire_at").flatpickr({
            enableTime: true,
            allowInput: true,
            dateFormat: "Y-m-d H:i:S",
            altInput: true,
            altFormat: "Y-m-d H:i:S",
            altInputClass: "gs-flatpickr-alt form-control input",
            disable: [
                function(date) {

                    const today = new Date();

                    // Remove time part from today's date for pure date compare
                    today.setHours(0, 0, 0, 0);

                    return date < today;

                }
            ],
            onReady: function(selectedDates, dateStr, instance) {
                // Add custom ID when alt input is ready
                instance.altInput.id = "gs_logo_expire_at_field";
            },
            dateFormat: "Y-m-d H:i:S"
        });
    }
    

    // If the title input is empty, prevent form submission and alert the user
    const titleInput = $('#title');
    const publishBtn = $('#publish');

    publishBtn.on('click', function (e) {
        const titleVal = titleInput.val().trim();

        if (titleVal === '') {
            e.preventDefault(); // Stop the form from submitting
            alert('⚠️ Please enter a Title before publishing or updating Logo.');
            titleInput.css({"border-color": "red", "box-shadow": "0 0 0 1px red"}).focus();
        }
    });

});