jQuery(function($) {

	var isValid = window._gslogo_sort_data.gs_logo_pro_is_valid;

	if ( isValid ) {
		var nonce = window._gslogo_sort_data.nonce;
		var action = window._gslogo_sort_data.action;
		$('.gs-plugins--sort-content').addClass('gsp-logo-premium-active');
	}

	var resourceSort = $('#sortable-list');

	resourceSort.sortable({

		update: function() {

			if ( ! isValid ) {
				alert('Please activate the pro version to use this feature');
				return;
			}

			var $loader = $('#loading-animation');

			$loader.fadeIn(100); // Show the animate loading gif while waiting

			$.ajax({
				url: ajaxurl, // ajaxurl is defined by WordPress and points to /wp-admin/admin-ajax.php
				type: 'POST',
				async: true,
				cache: false,
				dataType: 'json',
				data: {
					_nonce: nonce,
					action: action, // Tell WordPress how to handle this ajax request
					order: resourceSort.sortable('toArray').toString() // Passes ID's of list items in	1,3,2 format
				},
				success: function(response) {
					$loader.fadeOut(100); // Hide the loading animation
					return; 
				},
				error: function(xhr,textStatus,e) {  // This can be expanded to provide more information
					alert('There was an error saving the updates');
					$loader.fadeOut(100); // Hide the loading animation
					return; 
				}
			});

		}
		
	});

});